/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.sensorsimulator.db;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import org.openintents.sensorsimulator.db.SensorSimulator;

public class SensorSimulatorConvenience {
    private static final String TAG = "SensorSimulatorConvenience";
    private Context mContext;
    private ContentResolver mContentResolver;

    public SensorSimulatorConvenience(Context context) {
        this.mContext = context;
        this.mContentResolver = this.mContext.getContentResolver();
    }

    public void setPreference(String name, String value) {
        try {
            Cursor c;
            if (this.mContentResolver == null) {
                Log.i((String)TAG, (String)"Panic!.");
            }
            if ((c = this.mContentResolver.query(SensorSimulator.Settings.CONTENT_URI, SensorSimulator.SENSORSIMULATOR_PROJECTION, "key= '" + name + "'", null, "_id ASC")) == null) {
                Log.e((String)TAG, (String)"missing hardware provider");
                return;
            }
            if (c == null || c.getCount() < 1) {
                ContentValues values = new ContentValues(2);
                values.put("key", name);
                values.put("value", value);
                this.mContentResolver.insert(SensorSimulator.Settings.CONTENT_URI, values);
            } else if (c.getCount() >= 1) {
                c.moveToFirst();
                String id = c.getString(c.getColumnIndexOrThrow("_id"));
                ContentValues cv = new ContentValues();
                cv.put("value", value);
                this.mContentResolver.update(Uri.withAppendedPath((Uri)SensorSimulator.Settings.CONTENT_URI, (String)id), cv, null, null);
                c.getString(c.getColumnIndexOrThrow("value"));
            } else {
                Log.e((String)TAG, (String)"table 'settings' corrupt. Multiple KEY!");
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"setPreference() failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getPreference(String name) {
        try {
            Cursor c = this.mContentResolver.query(SensorSimulator.Settings.CONTENT_URI, SensorSimulator.SENSORSIMULATOR_PROJECTION, "key= '" + name + "'", null, "_id ASC");
            if (c.getCount() >= 1) {
                c.moveToFirst();
                return c.getString(c.getColumnIndexOrThrow("value"));
            }
            if (c.getCount() == 0) {
                return "";
            }
            Log.e((String)TAG, (String)"table 'preferences' corrupt. Multiple NAME!");
            return "";
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"insert into table 'contains' failed", (Throwable)e);
            return "Preferences table corrupt!";
        }
    }
}

