/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.sensorsimulator.hardware;

import android.content.Context;
import android.hardware.SensorListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.widget.Toast;
import org.openintents.sensorsimulator.hardware.SensorSimulatorClient;

public class SensorManagerSimulator {
    private static SensorManagerSimulator instance;
    private static final String TAG = "SensorManagerSimulator";
    private static SensorSimulatorClient mClient;
    private SensorManager mSensorManager = null;
    private Context mContext;

    private SensorManagerSimulator(Context context, SensorManager systemsensormanager) {
        this.mContext = context;
        this.mSensorManager = systemsensormanager;
        mClient = new SensorSimulatorClient(this.mContext);
    }

    public static SensorManagerSimulator getSystemService(Context context, String sensorManager) {
        if (instance == null && sensorManager.equals("sensor")) {
            if (SensorManagerSimulator.isRealSensorsAvailable()) {
                instance = new SensorManagerSimulator(context, (SensorManager)context.getSystemService(sensorManager));
            } else {
                instance = new SensorManagerSimulator(context, null);
                Toast.makeText((Context)context, (CharSequence)"Android SensorManager disabled, 1.5 SDK emulator crashes when using it... Make sure to connect SensorSimulator", (int)1).show();
            }
        }
        return instance;
    }

    public void setDefaultSensorManager(SensorManager sensormanager) {
        this.mSensorManager = sensormanager;
    }

    public int getSensors() {
        if (SensorManagerSimulator.mClient.connected) {
            return mClient.getSensors();
        }
        if (this.mSensorManager != null) {
            return this.mSensorManager.getSensors();
        }
        return 0;
    }

    private static boolean isRealSensorsAvailable() {
        return !Build.VERSION.SDK.equals("3") || !Build.MODEL.contains("sdk");
    }

    public boolean registerListener(SensorListener listener, int sensors, int rate) {
        if (SensorManagerSimulator.mClient.connected) {
            return mClient.registerListener(listener, sensors, rate);
        }
        if (this.mSensorManager == null) {
            return false;
        }
        return this.mSensorManager.registerListener(listener, sensors, rate);
    }

    public boolean registerListener(SensorListener listener, int sensors) {
        if (SensorManagerSimulator.mClient.connected) {
            return mClient.registerListener(listener, sensors);
        }
        if (this.mSensorManager == null) {
            return false;
        }
        return this.mSensorManager.registerListener(listener, sensors);
    }

    public void unregisterListener(SensorListener listener, int sensors) {
        if (SensorManagerSimulator.mClient.connected) {
            mClient.unregisterListener(listener, sensors);
        } else if (this.mSensorManager == null) {
            this.mSensorManager.unregisterListener(listener, sensors);
        }
    }

    public void unregisterListener(SensorListener listener) {
        if (SensorManagerSimulator.mClient.connected) {
            mClient.unregisterListener(listener);
        } else if (this.mSensorManager != null) {
            this.mSensorManager.unregisterListener(listener);
        }
    }

    public void connectSimulator() {
        mClient.connect();
    }

    public void disconnectSimulator() {
        mClient.disconnect();
    }

    public boolean isConnectedSimulator() {
        return SensorManagerSimulator.mClient.connected;
    }
}

