/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.sensorsimulator.hardware;

import android.util.Log;

public class SensorNames {
    public static final String SENSOR_ORIENTATION = "orientation";
    public static final String SENSOR_ACCELEROMETER = "accelerometer";
    public static final String SENSOR_TEMPERATURE = "temperature";
    public static final String SENSOR_MAGNETIC_FIELD = "magnetic field";
    public static final String SENSOR_LIGHT = "light";
    public static final String SENSOR_PROXIMITY = "proximity";
    public static final String SENSOR_TRICORDER = "tricorder";
    public static final String SENSOR_ORIENTATION_RAW = "orientation raw";
    public static final int SENSOR_MAX_BIT = 128;

    public static String getSensorName(int sensorbit) {
        switch (sensorbit) {
            case 1: {
                return SENSOR_ORIENTATION;
            }
            case 2: {
                return SENSOR_ACCELEROMETER;
            }
            case 4: {
                return SENSOR_TEMPERATURE;
            }
            case 8: {
                return SENSOR_MAGNETIC_FIELD;
            }
            case 16: {
                return SENSOR_LIGHT;
            }
            case 32: {
                return SENSOR_PROXIMITY;
            }
            case 64: {
                return SENSOR_TRICORDER;
            }
            case 128: {
                return SENSOR_ORIENTATION_RAW;
            }
        }
        Log.d((String)"Hardware", (String)("readSensor: Unknown sensor type " + sensorbit));
        return null;
    }

    public static int getSensorCount(int sensors) {
        int count = 0;
        for (int bit = 1; bit <= 128; bit <<= 1) {
            if ((sensors & bit) == 0) continue;
            ++count;
        }
        return count;
    }

    public static String[] getSensorNames(int sensors) {
        int num = SensorNames.getSensorCount(sensors);
        String[] s = new String[num];
        int pos = 0;
        for (int bit = 1; bit <= 128; bit <<= 1) {
            if ((sensors & bit) == 0) continue;
            s[pos] = SensorNames.getSensorName(bit);
            ++pos;
        }
        return s;
    }

    public static int getSensorsFromNames(String[] sensornames) {
        int sensors = 0;
        for (int i = 0; i < sensornames.length; ++i) {
            for (int bit = 1; bit <= 128; bit <<= 1) {
                if (!sensornames[i].equals(SensorNames.getSensorName(bit))) continue;
                sensors |= bit;
            }
        }
        return sensors;
    }

    public static int getNumSensorValues(int sensor) {
        switch (sensor) {
            case 1: 
            case 2: 
            case 8: 
            case 64: 
            case 128: {
                return 3;
            }
            case 4: 
            case 16: 
            case 32: {
                return 1;
            }
        }
        Log.d((String)"Hardware", (String)("getNumSensorValues: Unknown sensor type " + sensor));
        return 0;
    }
}

