/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.sensorsimulator.hardware;

import android.content.Context;
import android.hardware.SensorListener;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.openintents.sensorsimulator.db.SensorSimulatorConvenience;
import org.openintents.sensorsimulator.hardware.SensorNames;

final class SensorSimulatorClient {
    static final String TAG = "Hardware";
    private static final String TAG2 = "Hardware2";
    private static final boolean LOG_PROTOCOL = false;
    private Context mContext;
    private SensorSimulatorConvenience mSensorSimulatorConvenience;
    protected boolean connected = false;
    Socket mSocket;
    PrintWriter mOut;
    BufferedReader mIn;
    private ArrayList<Listener> mListeners = new ArrayList();
    private int DELAY_MS_FASTEST = 0;
    private int DELAY_MS_GAME = 20;
    private int DELAY_MS_UI = 60;
    private int DELAY_MS_NORMAL = 200;
    private static final int MSG_UPDATE_SENSORS = 1;
    private static int MAX_SENSOR = 5;
    private float[][] mValues = new float[MAX_SENSOR][];
    private boolean[] mValuesCached = new boolean[MAX_SENSOR];
    protected Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                long current = SystemClock.uptimeMillis();
                long nextTime = current + (long)SensorSimulatorClient.this.DELAY_MS_NORMAL;
                for (int i = 0; i < MAX_SENSOR; ++i) {
                    ((SensorSimulatorClient)SensorSimulatorClient.this).mValuesCached[i] = false;
                    if (SensorSimulatorClient.this.mValues[i] != null) continue;
                    Log.d((String)SensorSimulatorClient.TAG, (String)("Create cache for sensor " + i));
                    ((SensorSimulatorClient)SensorSimulatorClient.this).mValues[i] = new float[3];
                }
                for (Listener l : SensorSimulatorClient.this.mListeners) {
                    if (current >= l.mNextUpdateTime) {
                        int sensorbit = 1;
                        for (int i = 0; i < MAX_SENSOR; ++i) {
                            if (SensorSimulatorClient.hasSensor(l.mSensors, sensorbit)) {
                                if (!SensorSimulatorClient.this.mValuesCached[i]) {
                                    SensorSimulatorClient.this.readSensor(sensorbit, SensorSimulatorClient.this.mValues[i]);
                                    ((SensorSimulatorClient)SensorSimulatorClient.this).mValuesCached[i] = true;
                                }
                                l.mSensorListener.onSensorChanged(sensorbit, SensorSimulatorClient.this.mValues[i]);
                            }
                            sensorbit <<= 1;
                        }
                        l.mNextUpdateTime += l.mDelay;
                        if (l.mNextUpdateTime < current) {
                            l.mNextUpdateTime = current;
                        }
                    }
                    if (l.mNextUpdateTime >= nextTime) continue;
                    nextTime = l.mNextUpdateTime;
                }
                if (SensorSimulatorClient.this.mListeners.size() > 0) {
                    this.sendMessageAtTime(this.obtainMessage(1), nextTime);
                }
            }
        }
    };

    protected SensorSimulatorClient(Context context) {
        this.mContext = context;
        this.mSensorSimulatorConvenience = new SensorSimulatorConvenience(this.mContext);
    }

    protected void connect() {
        this.mSocket = null;
        this.mOut = null;
        this.mIn = null;
        Log.i((String)TAG, (String)"Starting connection...");
        String ipaddress = this.mSensorSimulatorConvenience.getPreference("IP address");
        String socket = this.mSensorSimulatorConvenience.getPreference("Socket");
        Log.i((String)TAG, (String)("Connecting to " + ipaddress + " : " + socket));
        try {
            this.mSocket = new Socket(ipaddress, Integer.parseInt(socket));
            this.mOut = new PrintWriter(this.mSocket.getOutputStream(), true);
            this.mIn = new BufferedReader(new InputStreamReader(this.mSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            Log.e((String)TAG, (String)("Don't know about host: " + ipaddress + " : " + socket));
            return;
        }
        catch (SocketTimeoutException e) {
            Log.e((String)TAG, (String)("Connection time out: " + ipaddress + " : " + socket));
            return;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Couldn't get I/O for the connection to: " + ipaddress + " : " + socket));
            Log.e((String)TAG, (String)"---------------------------------------------------------------");
            Log.e((String)TAG, (String)"Do you have the following permission in your manifest?");
            Log.e((String)TAG, (String)"<uses-permission android:name=\"android.permission.INTERNET\"/>");
            Log.e((String)TAG, (String)"---------------------------------------------------------------");
            System.exit(1);
        }
        Log.i((String)TAG, (String)"Read line...");
        String fromServer = "";
        try {
            fromServer = this.mIn.readLine();
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
        Log.i((String)TAG, (String)("Received: " + fromServer));
        if (fromServer.equals("SensorSimulator")) {
            this.connected = true;
            Log.i((String)TAG, (String)"Connected");
        } else {
            Log.i((String)TAG, (String)"Problem connecting: Wrong string sent.");
            this.disconnect();
        }
    }

    protected void disconnect() {
        if (this.connected) {
            Log.i((String)TAG, (String)"Disconnect()");
            try {
                this.mOut.close();
                this.mIn.close();
                this.mSocket.close();
            }
            catch (IOException e) {
                System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
                System.exit(1);
            }
            this.connected = false;
        }
    }

    protected int getSensors() {
        Log.i((String)TAG, (String)"getSensors");
        String[] sensornames = this.getSupportedSensors();
        Log.i((String)TAG, (String)("sensornames: " + sensornames.length));
        int sensors = SensorNames.getSensorsFromNames(sensornames);
        Log.i((String)TAG, (String)("sensors: " + sensors));
        return sensors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean registerListener(SensorListener listener, int sensors, int rate) {
        boolean result;
        int delay = -1;
        switch (rate) {
            case 0: {
                delay = this.DELAY_MS_FASTEST;
                break;
            }
            case 1: {
                delay = this.DELAY_MS_GAME;
                break;
            }
            case 2: {
                delay = this.DELAY_MS_UI;
                break;
            }
            case 3: {
                delay = this.DELAY_MS_NORMAL;
                break;
            }
            default: {
                return false;
            }
        }
        ArrayList<Listener> arrayList = this.mListeners;
        synchronized (arrayList) {
            Listener l = null;
            for (Listener i : this.mListeners) {
                if (i.mSensorListener != listener) continue;
                l = i;
                break;
            }
            if (l == null) {
                l = new Listener(listener, sensors, delay);
                result = this.enableSensor(sensors, delay);
                if (result) {
                    this.mListeners.add(l);
                    this.mListeners.notify();
                }
            } else {
                result = this.enableSensor(sensors, delay);
                if (result) {
                    l.addSensors(sensors, delay);
                }
            }
        }
        return result;
    }

    protected boolean registerListener(SensorListener listener, int sensors) {
        return this.registerListener(listener, sensors, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterListener(SensorListener listener, int sensors) {
        ArrayList<Listener> arrayList = this.mListeners;
        synchronized (arrayList) {
            int size = this.mListeners.size();
            for (int i = 0; i < size; ++i) {
                Listener l = this.mListeners.get(i);
                if (l.mSensorListener != listener) continue;
                this.enableSensor(sensors, -1);
                if (l.removeSensors(sensors) != 0) break;
                this.mListeners.remove(i);
                break;
            }
        }
    }

    protected void unregisterListener(SensorListener listener) {
        this.unregisterListener(listener, 127);
    }

    private boolean enableSensor(int sensors, int delay) {
        String[] sensornames = SensorNames.getSensorNames(sensors);
        boolean result = false;
        for (String sensor : sensornames) {
            try {
                if (delay == -1) {
                    this.disableSensor(sensor);
                } else {
                    this.enableSensor(sensor);
                    float updatesPerSecond = 1000.0f;
                    if (delay > 0) {
                        updatesPerSecond = 1000 / delay;
                    }
                    this.setSensorUpdateRate(sensor, updatesPerSecond);
                }
                result = true;
            }
            catch (IllegalArgumentException e) {
                Log.d((String)TAG, (String)("Sensor " + sensor + " not supported"));
            }
        }
        if (!this.mHandler.hasMessages(1)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
        }
        return result;
    }

    static boolean hasSensor(int sensors, int sensor) {
        return (sensors & sensor) != 0;
    }

    private void readSensor(int sensorbit, float[] sensorValues) {
        String sensorname = SensorNames.getSensorName(sensorbit);
        try {
            this.readSensor(sensorname, sensorValues);
        }
        catch (IllegalStateException e) {
            Log.d((String)TAG, (String)"Sensor not enabled -> enable it now");
            try {
                this.enableSensor(sensorname);
            }
            catch (IllegalArgumentException e2) {
                Log.d((String)TAG, (String)"Sensor not supported.");
            }
        }
    }

    protected int getNumSensorValues(int sensorbit) {
        String sensorname = SensorNames.getSensorName(sensorbit);
        return this.getNumSensorValues(sensorname);
    }

    protected void disableSensor(String sensor) {
        Log.i((String)TAG2, (String)"disableSensor()");
        this.mOut.println("disableSensor()");
        Log.i((String)TAG2, (String)("Send: " + sensor));
        this.mOut.println(sensor);
        try {
            String answer = this.mIn.readLine();
            if (answer.compareTo("throw IllegalArgumentException") == 0) {
                throw new IllegalArgumentException("Sensor '" + sensor + "' is not supported.");
            }
            Log.i((String)TAG2, (String)("Received: " + answer));
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
    }

    protected void enableSensor(String sensor) {
        Log.i((String)TAG2, (String)"enableSensor()");
        this.mOut.println("enableSensor()");
        Log.i((String)TAG2, (String)("Send: " + sensor));
        this.mOut.println(sensor);
        try {
            String answer = this.mIn.readLine();
            if (answer.compareTo("throw IllegalArgumentException") == 0) {
                throw new IllegalArgumentException("Sensor '" + sensor + "' is not supported.");
            }
            Log.i((String)TAG2, (String)("Received: " + answer));
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
    }

    protected String[] getSupportedSensors() {
        Log.i((String)TAG, (String)"getSupportedSensors()");
        this.mOut.println("getSupportedSensors()");
        String[] sensors = new String[]{""};
        int num = 0;
        try {
            String numstr = this.mIn.readLine();
            Log.i((String)TAG, (String)("Received: " + numstr));
            num = Integer.parseInt(numstr);
            sensors = new String[num];
            for (int i = 0; i < num; ++i) {
                sensors[i] = this.mIn.readLine();
                Log.i((String)TAG, (String)("Received: " + sensors[i]));
            }
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
        return sensors;
    }

    protected int getNumSensorValues(String sensor) {
        this.mOut.println("getNumSensorValues()");
        this.mOut.println(sensor);
        int num = 0;
        try {
            String numstr = this.mIn.readLine();
            if (numstr.compareTo("throw IllegalArgumentException") == 0) {
                throw new IllegalArgumentException("Sensor '" + sensor + "' is not supported.");
            }
            num = Integer.parseInt(numstr);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
        return num;
    }

    protected void readSensor(String sensor, float[] sensorValues) {
        if (sensorValues == null) {
            throw new NullPointerException("readSensor for '" + sensor + "' called with sensorValues == null.");
        }
        this.mOut.println("readSensor()\n" + sensor);
        int num = 0;
        try {
            String numstr = this.mIn.readLine();
            if (numstr.compareTo("throw IllegalArgumentException") == 0) {
                throw new IllegalArgumentException("Sensor '" + sensor + "' is not supported.");
            }
            if (numstr.compareTo("throw IllegalStateException") == 0) {
                throw new IllegalStateException("Sensor '" + sensor + "' is currently not enabled.");
            }
            num = Integer.parseInt(numstr);
            if (sensorValues.length < num) {
                throw new ArrayIndexOutOfBoundsException("readSensor for '" + sensor + "' called with sensorValues having too few elements (" + sensorValues.length + ") to hold the sensor values (" + num + ").");
            }
            for (int i = 0; i < num; ++i) {
                String val = this.mIn.readLine();
                sensorValues[i] = Float.parseFloat(val);
            }
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
    }

    protected float[] getSensorUpdateRates(String sensor) {
        this.mOut.println("getSensorUpdateRates()");
        float[] rates = null;
        this.mOut.println(sensor);
        int num = 0;
        try {
            String numstr = this.mIn.readLine();
            if (numstr.compareTo("throw IllegalArgumentException") == 0) {
                throw new IllegalArgumentException("Sensor '" + sensor + "' is not supported.");
            }
            num = Integer.parseInt(numstr);
            if (num > 0) {
                rates = new float[num];
                for (int i = 0; i < num; ++i) {
                    rates[i] = Float.parseFloat(this.mIn.readLine());
                }
            } else {
                rates = null;
            }
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
        return rates;
    }

    protected float getSensorUpdateRate(String sensor) {
        Log.i((String)TAG, (String)"getSensorUpdateRate()");
        this.mOut.println("getSensorUpdateRate()");
        float rate = 0.0f;
        Log.i((String)TAG, (String)("Send: " + sensor));
        this.mOut.println(sensor);
        try {
            String numstr = this.mIn.readLine();
            if (numstr.compareTo("throw IllegalArgumentException") == 0) {
                throw new IllegalArgumentException("Sensor '" + sensor + "' is not supported.");
            }
            if (numstr.compareTo("throw IllegalStateException") == 0) {
                throw new IllegalStateException("Sensor '" + sensor + "' is currently not enabled.");
            }
            Log.i((String)TAG, (String)("Received: " + numstr));
            rate = Float.parseFloat(numstr);
            Log.i((String)TAG, (String)("Received: " + rate));
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
        return rate;
    }

    protected void setSensorUpdateRate(String sensor, float updatesPerSecond) {
        Log.i((String)TAG, (String)"setSensorUpdateRate()");
        this.mOut.println("setSensorUpdateRate()");
        Log.i((String)TAG, (String)("Send: " + sensor));
        this.mOut.println(sensor);
        try {
            String numstr = this.mIn.readLine();
            if (numstr.compareTo("throw IllegalArgumentException") == 0) {
                throw new IllegalArgumentException("Sensor '" + sensor + "' is not supported.");
            }
            Log.i((String)TAG, (String)("Received: " + numstr));
            Log.i((String)TAG, (String)("Send: " + updatesPerSecond));
            this.mOut.println("" + updatesPerSecond);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
    }

    protected void unsetSensorUpdateRate(String sensor) {
        Log.i((String)TAG, (String)"unsetSensorUpdateRate()");
        this.mOut.println("unsetSensorUpdateRate()");
        Log.i((String)TAG, (String)("Send: " + sensor));
        this.mOut.println(sensor);
        try {
            String numstr = this.mIn.readLine();
            if (numstr.compareTo("throw IllegalArgumentException") == 0) {
                throw new IllegalArgumentException("Sensor '" + sensor + "' is not supported.");
            }
            Log.i((String)TAG, (String)("Received: " + numstr));
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: x.x.x.x.");
            System.exit(1);
        }
    }

    private class Listener {
        private SensorListener mSensorListener;
        private int mSensors;
        private int mDelay;
        private long mNextUpdateTime;

        int addSensors(int sensors, int delay) {
            this.mSensors |= sensors;
            if (delay < this.mDelay) {
                this.mDelay = delay;
                this.mNextUpdateTime = 0L;
            }
            return this.mSensors;
        }

        int removeSensors(int sensors) {
            this.mSensors &= ~sensors;
            return this.mSensors;
        }

        boolean hasSensor(int sensor) {
            return (this.mSensors & sensor) != 0;
        }

        Listener(SensorListener listener, int sensors, int delay) {
            this.mSensorListener = listener;
            this.mSensors = sensors;
            this.mDelay = delay;
            this.mNextUpdateTime = 0L;
        }
    }
}

