/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.sensorsimulator.hardware;

import android.content.Context;
import org.openintents.sensorsimulator.hardware.SensorSimulatorClient;

final class Sensors {
    private static final String TAG = "Hardware";
    private SensorSimulatorClient mClient;
    private Context mContext;

    protected Sensors(Context context) {
        this.mContext = context;
        this.mClient = new SensorSimulatorClient(this.mContext);
    }

    protected void disableSensor(String sensor) {
        if (this.mClient.connected) {
            this.mClient.disableSensor(sensor);
        }
    }

    protected void enableSensor(String sensor) {
        if (this.mClient.connected) {
            this.mClient.enableSensor(sensor);
        }
    }

    protected int getNumSensorValues(String sensor) {
        if (this.mClient.connected) {
            return this.mClient.getNumSensorValues(sensor);
        }
        return 0;
    }

    protected float getSensorUpdateRate(String sensor) {
        if (this.mClient.connected) {
            return this.mClient.getSensorUpdateRate(sensor);
        }
        return 0.0f;
    }

    protected float[] getSensorUpdateRates(String sensor) {
        if (this.mClient.connected) {
            return this.mClient.getSensorUpdateRates(sensor);
        }
        return null;
    }

    protected String[] getSupportedSensors() {
        if (this.mClient.connected) {
            return this.mClient.getSupportedSensors();
        }
        return new String[0];
    }

    protected void readSensor(String sensor, float[] sensorValues) {
        if (this.mClient.connected) {
            this.mClient.readSensor(sensor, sensorValues);
        }
    }

    protected void setSensorUpdateRate(String sensor, float updatesPerSecond) {
        if (this.mClient.connected) {
            this.mClient.setSensorUpdateRate(sensor, updatesPerSecond);
        }
    }

    protected void unsetSensorUpdateRate(String sensor) {
        if (this.mClient.connected) {
            this.mClient.unsetSensorUpdateRate(sensor);
        }
    }

    protected void connectSimulator() {
        this.mClient.connect();
    }

    protected void disconnectSimulator() {
        this.mClient.disconnect();
    }
}

