package com.marakana;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;

// implement SensorListener
public class Compass extends Activity implements SensorEventListener { // <1>
  SensorManager sensorManager; // <2>
  Sensor sensor;
  Rose rose;

  /** Called when the activity is first created. */
  @Override
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    // Set full screen view <3>
    getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
        WindowManager.LayoutParams.FLAG_FULLSCREEN);
    requestWindowFeature(Window.FEATURE_NO_TITLE);

    // Create new instance of custom Rose and set it on the screen
    rose = new Rose(this); // <4>
    setContentView(rose); // <5>

    // Get sensor and sensor manager
    sensorManager = (SensorManager) getSystemService(SENSOR_SERVICE); // <6>
    sensor = sensorManager.getDefaultSensor(Sensor.TYPE_ORIENTATION); // <7>

    Log.d("Compass", "onCreate'd");
  }

  // Register to listen to sensors
  @Override
  public void onResume() {
    super.onResume();
    sensorManager.registerListener(this, sensor,
        SensorManager.SENSOR_DELAY_NORMAL); // <8>
  }

  // Unregister the sernsor listener
  @Override
  public void onPause() {
    super.onPause();
    sensorManager.unregisterListener(this); // <9>
  }

  // Ignore accuracy changes 
  public void onAccuracyChanged(Sensor sensor, int accuracy) { // <10>
  }

  // Listen to sensor and provide output
  public void onSensorChanged(SensorEvent event) { // <11>
    int orientation = (int) event.values[0]; // <12>
    rose.setDirection(orientation); // <13>
  }
}