package gov.sandia;

public class FibLib {

	/*
	 * fib(0) = 0 fib(1) = 1 fib(n) = fib(n-1) + fib(n-2)
	 */

	// Java implementation
	public static int fibJ(int n) {
		if (n == 0)
			return 0;
		if (n == 1)
			return 1;
		return fibJ(n - 1) + fibJ(n - 2);
	}

	static {
		System.loadLibrary("fib");
	}

	// Native version
	public static native int fibN(int n);
}
