package gov.sandia;

import java.util.List;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.widget.TextView;

public class WifiActivity extends Activity {
	TextView textOut;
	WifiManager wifiManager;
	ScanReceiver scanReceiver;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.standard);

		// Find views
		((TextView) findViewById(R.id.textTitle)).setText("Wifi");
		textOut = (TextView) findViewById(R.id.textOut);

		// Register scan receiver
		scanReceiver = new ScanReceiver();
		registerReceiver(scanReceiver, new IntentFilter(
				WifiManager.SCAN_RESULTS_AVAILABLE_ACTION));

		// Get wifi manager
		wifiManager = (WifiManager) getSystemService(WIFI_SERVICE);
		wifiManager.startScan(); // non-blocking call

	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		unregisterReceiver(scanReceiver);
	}

	// Scan receiver
	class ScanReceiver extends BroadcastReceiver {

		@Override
		public void onReceive(Context context, Intent intent) {
			textOut.setText("");

			// List configured networks
			List<WifiConfiguration> confs = wifiManager.getConfiguredNetworks();
			for (WifiConfiguration conf : confs) {
				textOut.append("\n" + conf.SSID);
			}

			textOut.append("\n\nAvailable networks:");
			List<ScanResult> list = wifiManager.getScanResults();
			for (ScanResult result : list) {
				textOut.append("\n" + result.SSID);
			}
		}

	}
}
