package com.marakana;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;

public class UpdaterService extends Service {   //<1>
  static final String TAG = "UpdaterService";
  static final int DELAY = 30000; // 1/2 a min
  UpdaterRunnable updaterRunnable;
  Handler handler;

  @Override
  public IBinder onBind(Intent intent) {  // <2> 
    return null;
  }

  @Override
  public void onCreate() {
    super.onCreate();

    // Initialize handler & runnable
    handler = new Handler();    // <3>
    updaterRunnable = new UpdaterRunnable();    // <4>
    handler.post(updaterRunnable);    // <5>

    Log.d(TAG, "onCreate'd");
  }

  @Override
  public void onStart(Intent intent, int startId) {   // <6>
    super.onStart(intent, startId);
    Log.d(TAG, "onStart'd");
  }

  @Override
  public void onDestroy() {   // <7>
    super.onDestroy();

    // Cleanup handler & runnable
    handler.removeCallbacks(updaterRunnable);
    updaterRunnable = null;
    handler = null;

    Log.d(TAG, "onDestroy'd");
  }

  class UpdaterRunnable implements Runnable {   // <8>

    public void run() {
      Log.d(TAG, "UpdaterRunnable run'd");

      handler.postDelayed(updaterRunnable, DELAY);    // <9>
    }

  }
}
