package com.marakana;

import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;
import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

public class StatusActivity extends Activity implements OnClickListener,
    OnSharedPreferenceChangeListener {
  EditText editText;
  Button updateButton;
  Twitter twitter;
  SharedPreferences prefs;
  String username, password;

  /** Called when the activity is first created. */
  @Override
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.main);

    // Find views
    editText = (EditText) findViewById(R.id.editText);
    updateButton = (Button) findViewById(R.id.buttonUpdate);

    updateButton.setOnClickListener(this);

    // Setup preferences
    prefs = PreferenceManager.getDefaultSharedPreferences(this);
    prefs.registerOnSharedPreferenceChangeListener(this);
  }

  public void onClick(View v) {

    // Create new thread
    new Thread() {
      public void run() {

        // Update twitter status
        try {
          getTwitter().setStatus(editText.getText().toString());
        } catch (TwitterException e) {
          Log.d("MyTwitter", "Twitter setStatus failed: " + e);
        }

      }
    }.start();

  }

  // Called first time user clicks on the menu button
  @Override
  public boolean onCreateOptionsMenu(Menu menu) {
    MenuInflater inflater = getMenuInflater();
    inflater.inflate(R.menu.menu, menu);
    return true;
  }

  // Called when an options item is clicked
  @Override
  public boolean onOptionsItemSelected(MenuItem item) {
    switch (item.getItemId()) {
    case R.id.itemServiceStart:
      startService(new Intent(this, UpdaterService.class));
      break;
    case R.id.itemServiceStop:
      stopService(new Intent(this, UpdaterService.class));
      break;
    case R.id.itemPrefs:
      startActivity(new Intent(this, PrefsActivity.class));
      break;
    case R.id.itemTimeline:
      startActivity(new Intent(this, TimelineActivity.class));
      break;
    }

    return true;
  }

  private Twitter getTwitter() {
    if (twitter == null) {
      username = prefs.getString("username", "");
      password = prefs.getString("password", "");

      // Connect to twitter.com
      twitter = new Twitter(username, password);
      twitter.setAPIRootUrl("http://128.242.240.61:80");
    }
    return twitter;
  }

  public void onSharedPreferenceChanged(SharedPreferences prefs, String key) {
    // invalidate twitter
    twitter = null;
  }

}