package com.marakana;

import java.util.List;

import winterwell.jtwitter.Twitter;
import winterwell.jtwitter.TwitterException;
import winterwell.jtwitter.Twitter.Status;
import android.app.Service;
import android.content.ContentValues;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.IBinder;
import android.preference.PreferenceManager;
import android.util.Log;

public class UpdaterService extends Service implements
    OnSharedPreferenceChangeListener {
  static final String TAG = "UpdaterService";
  static final int DELAY = 30000; // 1/2 a min
  UpdaterRunnable updaterRunnable;
  Handler handler;
  Twitter twitter;
  SharedPreferences prefs;
  String username, password;
  DbHelper dbHelper;
  SQLiteDatabase db;

  @Override
  public IBinder onBind(Intent intent) {
    return null;
  }

  @Override
  public void onCreate() {
    super.onCreate();

    // Open the database
    dbHelper = new DbHelper(this);
    db = dbHelper.getWritableDatabase();

    // Setup preferences
    prefs = PreferenceManager.getDefaultSharedPreferences(this);
    prefs.registerOnSharedPreferenceChangeListener(this);

    // Initialize handler & runnable
    handler = new Handler();
    updaterRunnable = new UpdaterRunnable();
    handler.post(updaterRunnable);

    Log.d(TAG, "onCreate'd");
  }

  @Override
  public void onStart(Intent intent, int startId) {
    super.onStart(intent, startId);
    Log.d(TAG, "onStart'd");
  }

  @Override
  public void onDestroy() {
    super.onDestroy();

    // Cleanup handler & runnable
    handler.removeCallbacks(updaterRunnable);
    updaterRunnable = null;
    handler = null;

    // Close the database
    db.close();

    Log.d(TAG, "onDestroy'd");
  }

  class UpdaterRunnable implements Runnable {
    public void run() {
      pullFromTwitter();

      Log.d(TAG, "UpdaterRunnable run'd");

      // Do this again
      handler.postDelayed(updaterRunnable, DELAY);
    }
  }

  // The actual work of connecting to twitter and getting latest data
  private void pullFromTwitter() {
    List<Status> timeline = null;
    try {
      timeline = getTwitter().getFriendsTimeline();
    } catch (TwitterException e) {
      e.printStackTrace();
    }

    ContentValues values = new ContentValues();
    // Loop over the timeline and print it out
    for (Status status : timeline) {
      // Insert into database
      values.put(DbHelper.C_ID, status.id);
      values.put(DbHelper.C_CREATED_AT, status.createdAt.getTime());
      values.put(DbHelper.C_SOURCE, status.source);
      values.put(DbHelper.C_TEXT, status.text);
      values.put(DbHelper.C_USER, status.user.name);
      try {
        db.insertOrThrow(DbHelper.TABLE, null, values);
        Log.d(TAG, String.format("%s: %s", status.user.name, status.text));
      } catch (SQLException e) {
      }

    }
  }

  private Twitter getTwitter() {
    if (twitter == null) {
      username = prefs.getString("username", "");
      password = prefs.getString("password", "");

      // Connect to twitter.com
      twitter = new Twitter(username, password);
    }
    return twitter;
  }

  public void onSharedPreferenceChanged(SharedPreferences prefs, String key) {
    // invalidate twitter
    twitter = null;
  }
}
