package com.marakana;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.util.Log;
import android.widget.ListView;

public class TimelineActivity extends Activity {
  DbHelper dbHelper;
  SQLiteDatabase db;
  Cursor cursor;
  ListView listTimeline;
  TimelineAdapter adapter;
  TimelineReceiver receiver;
  IntentFilter filter;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.timeline);

    // Find your views
    listTimeline = (ListView) findViewById(R.id.listTimeline);

    // Connect to database
    dbHelper = new DbHelper(this);
    db = dbHelper.getReadableDatabase();

    // Create the receiver
    receiver = new TimelineReceiver();
    filter = new IntentFilter("Marakana.Twitter.NEW_STATUS");
  }

  @Override
  public void onDestroy() {
    super.onDestroy();

    // Close the database
    db.close();
  }

  @Override
  protected void onResume() {
    super.onResume();

    // Get the data from the database
    cursor = db.query(DbHelper.TABLE, null, null, null, null, null,
        DbHelper.C_CREATED_AT + " DESC");
    startManagingCursor(cursor);

    // Create the adapter
    adapter = new TimelineAdapter(this, cursor);
    listTimeline.setAdapter(adapter);

    // Register the receiver
    registerReceiver(receiver, filter);
  }

  @Override
  protected void onPause() {
    super.onPause();

    // UNregister the receiver
    unregisterReceiver(receiver);
  }

  class TimelineReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
      cursor.requery();
      Log.d("TimelineReceiver", "onReceive'd");
    }
  }
}
