package com.marakana.test;

import android.test.ActivityInstrumentationTestCase2;
import android.test.TouchUtils;
import android.test.ViewAsserts;
import android.test.suitebuilder.annotation.SmallTest;
import android.widget.EditText;

import com.marakana.TestDemo;

/*
 * Test code to test com.marakana.TestDemo
 * 
 * To run on command line:
 * adb -e shell am instrument -w -e class com.marakana.test.TestDemoTests 
 *              com.marakana.test/android.test.InstrumentationTestRunner
 */
public class TestDemoTests extends ActivityInstrumentationTestCase2<TestDemo> { // <1>
  EditText editKilos, editPounds;
  TestDemo activity; // <2>

  public TestDemoTests(String name) { // <3>
    super("com.marakana", TestDemo.class);
    setName(name);
  }

  protected void setUp() throws Exception { // <4>
    super.setUp();

    // Find views
    activity = getActivity(); // <5>
    editKilos = (EditText) activity.findViewById(com.marakana.R.id.editKilos); // <6>
    editPounds = (EditText) activity.findViewById(com.marakana.R.id.editPounds); // <7>
  }

  protected void tearDown() throws Exception { // <8>
    super.tearDown();
  }

  @SmallTest
  public void testViewsCreated() {  // <9>
    assertNotNull(getActivity());
    assertNotNull(editKilos);
    assertNotNull(editPounds);
  }

  @SmallTest
  public void testViewsVisible() { // <10>
    ViewAsserts.assertOnScreen(editKilos.getRootView(), editPounds);
    ViewAsserts.assertOnScreen(editPounds.getRootView(), editKilos);
  }

  @SmallTest
  public void testStartingEmpty() { // <11>
    assertTrue("Kilos field is empty",
        "".equals(editKilos.getText().toString()));
    assertTrue("Pounds field is empty",
        "".equals(editPounds.getText().toString()));
  }

  @SmallTest
  public void testKilosToPounds() { // <12>
    editKilos.clearComposingText();
    editPounds.clearComposingText();

    TouchUtils.tapView(this, editKilos); // <13>
    sendKeys("1"); // <14>

    double pounds;
    try {
      pounds = Double.parseDouble(editPounds.getText().toString());
    } catch (NumberFormatException e) {
      pounds = -1;
    }
    assertTrue("1 kilo is 2.20462262 pounds", pounds > 2.2 && pounds < 2.3); // <15>
  }

}
