package com.marakana;

import android.app.Activity;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnKeyListener;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.EditText;

public class WebBrowser extends Activity {
  private WebView webView; // <1>
  private EditText urlField;
  private Button goButton;

  /** Called when the activity is first created. */
  @Override
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.main);

    // Create reference to UI elements
    webView = (WebView) findViewById(R.id.webview_compontent);
    urlField = (EditText) findViewById(R.id.url);
    goButton = (Button) findViewById(R.id.go_button);

    // workaround so that the default browser doesn't take over
    webView.setWebViewClient(new MyWebViewClient()); // <2>

    // Setup click listener
    goButton.setOnClickListener(new OnClickListener() { // <3>
      public void onClick(View view) {
        webView.loadUrl(urlField.getText().toString()); // <4>
      }
    });

    // Setup key listener
    urlField.setOnKeyListener(new OnKeyListener() { // <5>
      public boolean onKey(View view, int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_ENTER) {
          webView.loadUrl(urlField.getText().toString());
          return true;
        } else {
          return false;
        }
      }
    });

  }

  // Our WebViewClient, to keep opening URLs within our component by default <6>
  private class MyWebViewClient extends WebViewClient {
    @Override
    public boolean shouldOverrideUrlLoading(WebView webView, String url) {  // <7>
      webView.loadUrl(url);
      return true;
    }
  }
}
