/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.phonegap.DirectoryManager;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileUtils
extends Plugin {
    public static int NOT_FOUND_ERR = 1;
    public static int SECURITY_ERR = 2;
    public static int ABORT_ERR = 3;
    public static int NOT_READABLE_ERR = 4;
    public static int ENCODING_ERR = 5;
    public static int NO_MODIFICATION_ALLOWED_ERR = 6;
    public static int INVALID_STATE_ERR = 7;
    public static int SYNTAX_ERR = 8;
    FileReader f_in;
    FileWriter f_out;

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("testSaveLocationExists")) {
                boolean b = DirectoryManager.testSaveLocationExists();
                return new PluginResult(status, b);
            }
            if (action.equals("getFreeDiskSpace")) {
                long l = DirectoryManager.getFreeDiskSpace();
                return new PluginResult(status, l);
            }
            if (action.equals("testFileExists")) {
                boolean b = DirectoryManager.testFileExists(args.getString(0));
                return new PluginResult(status, b);
            }
            if (action.equals("testDirectoryExists")) {
                boolean b = DirectoryManager.testFileExists(args.getString(0));
                return new PluginResult(status, b);
            }
            if (action.equals("deleteDirectory")) {
                boolean b = DirectoryManager.deleteDirectory(args.getString(0));
                return new PluginResult(status, b);
            }
            if (action.equals("deleteFile")) {
                boolean b = DirectoryManager.deleteFile(args.getString(0));
                return new PluginResult(status, b);
            }
            if (action.equals("createDirectory")) {
                boolean b = DirectoryManager.createDirectory(args.getString(0));
                return new PluginResult(status, b);
            }
            if (action.equals("getRootPaths")) {
                return new PluginResult(status, DirectoryManager.getRootPaths());
            }
            if (action.equals("readAsText")) {
                try {
                    String s = this.readAsText(args.getString(0), args.getString(1));
                    return new PluginResult(status, s);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return new PluginResult(PluginResult.Status.ERROR, NOT_FOUND_ERR);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new PluginResult(PluginResult.Status.ERROR, NOT_READABLE_ERR);
                }
            }
            if (action.equals("readAsDataURL")) {
                try {
                    String s = this.readAsDataURL(args.getString(0));
                    return new PluginResult(status, s);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return new PluginResult(PluginResult.Status.ERROR, NOT_FOUND_ERR);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new PluginResult(PluginResult.Status.ERROR, NOT_READABLE_ERR);
                }
            }
            if (action.equals("writeAsText")) {
                try {
                    this.writeAsText(args.getString(0), args.getString(1), args.getBoolean(2));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return new PluginResult(PluginResult.Status.ERROR, NOT_FOUND_ERR);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new PluginResult(PluginResult.Status.ERROR, NOT_READABLE_ERR);
                }
            } else {
                if (action.equals("write")) {
                    try {
                        long fileSize = this.write(args.getString(0), args.getString(1), args.getLong(2));
                        return new PluginResult(status, fileSize);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        return new PluginResult(PluginResult.Status.ERROR, NOT_FOUND_ERR);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return new PluginResult(PluginResult.Status.ERROR, NOT_READABLE_ERR);
                    }
                }
                if (action.equals("truncate")) {
                    try {
                        long fileSize = this.truncateFile(args.getString(0), args.getLong(1));
                        return new PluginResult(status, fileSize);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        return new PluginResult(PluginResult.Status.ERROR, NOT_FOUND_ERR);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return new PluginResult(PluginResult.Status.ERROR, NOT_READABLE_ERR);
                    }
                }
                if (action.equals("getFile")) {
                    JSONObject obj = DirectoryManager.getFile(args.getString(0));
                    return new PluginResult(status, obj);
                }
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public boolean isSynch(String action) {
        if (action.equals("readAsText")) {
            return false;
        }
        if (action.equals("readAsDataURL")) {
            return false;
        }
        return !action.equals("writeAsText");
    }

    public String readAsText(String filename, String encoding) throws FileNotFoundException, IOException {
        byte[] bytes = new byte[1000];
        BufferedInputStream bis = new BufferedInputStream(this.getPathFromUri(filename), 1024);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int numRead = 0;
        while ((numRead = bis.read(bytes, 0, 1000)) >= 0) {
            bos.write(bytes, 0, numRead);
        }
        return new String(bos.toByteArray(), encoding);
    }

    public String readAsDataURL(String filename) throws FileNotFoundException, IOException {
        byte[] bytes = new byte[1000];
        BufferedInputStream bis = new BufferedInputStream(this.getPathFromUri(filename), 1024);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int numRead = 0;
        while ((numRead = bis.read(bytes, 0, 1000)) >= 0) {
            bos.write(bytes, 0, numRead);
        }
        String contentType = null;
        if (filename.startsWith("content:")) {
            Uri fileUri = Uri.parse((String)filename);
            contentType = this.ctx.getContentResolver().getType(fileUri);
        } else {
            MimeTypeMap map = MimeTypeMap.getSingleton();
            contentType = map.getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl((String)filename));
        }
        byte[] base64 = Base64.encodeBase64((byte[])bos.toByteArray());
        String data = "data:" + contentType + ";base64," + new String(base64);
        return data;
    }

    public void writeAsText(String filename, String data, boolean append) throws FileNotFoundException, IOException {
        String FilePath = filename;
        byte[] rawData = data.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(rawData);
        FileOutputStream out = new FileOutputStream(FilePath, append);
        byte[] buff = new byte[rawData.length];
        in.read(buff, 0, buff.length);
        out.write(buff, 0, rawData.length);
        out.flush();
        out.close();
    }

    public long write(String filename, String data, long offset) throws FileNotFoundException, IOException {
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        file.seek(offset);
        file.writeBytes(data);
        file.close();
        return data.length();
    }

    private long truncateFile(String filename, long size) throws FileNotFoundException, IOException {
        RandomAccessFile raf = new RandomAccessFile(filename, "rw");
        if (raf.length() >= size) {
            FileChannel channel = raf.getChannel();
            channel.truncate(size);
            return size;
        }
        return raf.length();
    }

    private InputStream getPathFromUri(String path) throws FileNotFoundException {
        if (path.startsWith("content")) {
            Uri uri = Uri.parse((String)path);
            return this.ctx.getContentResolver().openInputStream(uri);
        }
        return new FileInputStream(path);
    }
}

