/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.util.SimpleTempStorage;
import org.apache.james.mime4j.util.TempPath;

public abstract class TempStorage {
    private static Log log = LogFactory.getLog((Class)TempStorage.class);
    private static TempStorage inst = null;

    public abstract TempPath getRootTempPath();

    public static TempStorage getInstance() {
        return inst;
    }

    public static void setInstance(TempStorage inst) {
        if (inst == null) {
            throw new NullPointerException("inst");
        }
        TempStorage.inst = inst;
    }

    static {
        String clazz = System.getProperty("org.apache.james.mime4j.tempStorage");
        try {
            if (inst != null) {
                inst = (TempStorage)Class.forName(clazz).newInstance();
            }
        }
        catch (Throwable t) {
            log.warn((Object)("Unable to create or instantiate TempStorage class '" + clazz + "' using SimpleTempStorage instead"), t);
        }
        if (inst == null) {
            inst = new SimpleTempStorage();
        }
    }
}

