package net.multitool.core;        // Copyright (C) 2004 by Carl Albing and Michael Schwarz
                                   // Licensed under the terms of the GNU GPL version 2.  
import net.multitool.util.*;
import java.util.*;
import java.sql.*;

public class
Account
{
   private String name;                 // a name to identify this account
   private User owner;                  // the user assigned to this account
   private SAMoney total;               // total amt originally allocated to this account
   private SAMoney balance;             // amt remaining unalloacted to any subaccounts
   private Account parent;              // the account which contains this account as a child
   private HashMap children;            // the collection of subaccounts, by name
   private static Connection dbConn = null;	// JDBC connection
   private ArrayList payments;          // TODO: unimplemented
   private SAMoney unspent;             // TODO: unimplemented

   /**
    * Create an account, with a pool of dollars to budget.
    * Use this constructor to create the master account.
    * Use "createSub" to create children of this account.
    */
   public
   Account(String name, User owner, String total)
      throws NumberFormatException
   {
      this.name = name;
      this.owner = owner;
      this.total = new SAMoney(Double.valueOf(total).doubleValue());
      this.balance = new SAMoney(Double.valueOf(total).doubleValue()); // N.B. must not be the same object
      this.parent = null;
      this.children = new HashMap();
   }

   // static that connects to the DB and either returns the top account,
   // or creates it for us.
   public static Account getTopAccount() throws SQLException {
	Account topAccount = null;

	dbConn = DriverManager.getConnection("jdbc:postgresql:budgetPro?user=mschwarz");

	if (dbConn != null) {
		// We have a database connection
	} else {
		// We don't and we must create a top account
	}

	return topAccount;
   }


   // simple getter; returns the name
   public String
   getName() { return name; } // getName

   // simple getter; returns the total pool of money that this account represents
   public SAMoney
   getTotal() { return total; } // getTotal

   // simple getter; returns the balance
   public SAMoney
   getBalance() { return balance; } // getBalance

   // simple getter; returns the parent account
   public Account
   getParent() { return parent; } // getParent

   /**
    * simple getter; returns the owner of this account,
	* as a User object.
	*/
   public User
   getOwner()
   {
	  return owner;
   } // getOwner

   // census - how many children
   public int
   size() { return children.size(); } // size

   /**
    * get to all the children, via an iterator
    */
   public Iterator
   getAllSubs()
   {
      return children.values().iterator();

   } // getAllSubs

   /**
    * Create a new sub account (i.e. child)
    * given a name and an amount.
    * The child is connected to the parent, and
    * the parent's balance is reduced by the amount
    * allocated to the child.
    */
   public Account
   createSub(String name, String amt)
      throws NumberFormatException
   {
      Account acct = new Account(name, owner, amt);

      // reduce the parent's unallocated funds
      balance = balance.subtract(acct.getTotal());

      // connect the accounts to each other
      acct.parent = this;
      children.put(name, acct);

      return acct;

   } // createChild

   /**
    * Looks up and returns the account
    * with the given name.
    */
   public Account
   getSub(String name)
   {
      return (Account) children.get(name);

   } // getSub

} // class Account

