package net.multitool.gui;         // Copyright (C) 2004 by Carl Albing and Michael Schwarz
                                   // Licensed under the terms of the GNU GPL version 2.  
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import java.util.*;
import net.multitool.core.*;

class
AcctDialog
  extends JDialog
{
  JDialog dialog;    // for reference from the buttons' actions
  JTextField nameField;
  JTextField amntField;

  AcctDialog(JFrame frame, String title)
  {
    super(frame, title, true);
    dialog = this;
    nameField = new JTextField(25);
    amntField = new JTextField(9);

    // right justify the numeric field
    amntField.setHorizontalAlignment(JTextField.RIGHT);

    // TODO: so that <Enter> will do a create
    // this.getInputMap().put(KeyStroke.getKeyStroke("Enter"), "create");
    /*
      Action myAction = new AbstractAction("doSomething") {
        public void actionPerformed() {
          doSomething();
        }
      };
      myComponent.getActionMap().put(myAction.get(Action.NAME), myAction);
     */

    //--------------------------------------------------Label on top----
    JLabel label = new JLabel("<html><p align=left><i>"
                   + "Enter the info to create a subaccount.<br>"
                   + "</i>");
    label.setHorizontalAlignment(JLabel.LEFT);
    Font font = label.getFont();
    label.setFont(label.getFont().deriveFont(font.PLAIN, 14.0f));

    //--------------------------------------------------Text Fields-----
    String[] labels = {"(Sub)Account Name: ", "Dollar Amount: "};
    JTextField [] fields = {nameField, amntField};
    int numPairs = fields.length;

    //Create and populate the panel.
    JPanel textes = new JPanel(new SpringLayout());
    for (int i = 0; i < numPairs; i++) {
      JLabel l = new JLabel(labels[i], JLabel.TRAILING);
      textes.add(l);
      l.setLabelFor(fields[i]);  // not nec. since we have no kb shortcuts
      textes.add(fields[i]);
    }

    //Lay out the panel.
    SpringUtilities.makeCompactGrid(textes,
                                    numPairs, 2, //rows, cols
                                    6, 6,        //initX, initY
                                    6, 6);       //xPad, yPad


    //--------------------------------------------------Buttons on bottom
    JButton createButton = new JButton("Create");
    createButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        nameField.grabFocus(); // before leaving, ready for next time.
        dialog.setVisible(false);   // go away
      }
    });

    JButton cancelButton = new JButton("Cancel");
    cancelButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        clear(); // toss out any entry
        dialog.setVisible(false);
      }
    });
    getRootPane().setDefaultButton(createButton);

    JPanel closePanel = new JPanel();
    closePanel.setLayout(new BoxLayout(closePanel, BoxLayout.LINE_AXIS));
    closePanel.add(Box.createHorizontalGlue());
    closePanel.add(createButton);
    closePanel.add(Box.createRigidArea(new Dimension(5, 0)));
    closePanel.add(cancelButton);
    closePanel.setBorder(BorderFactory.createEmptyBorder(10,0,5,5));

    JPanel contentPane = new JPanel(new BorderLayout());
    contentPane.add(label, BorderLayout.PAGE_START);
    contentPane.add(textes, BorderLayout.CENTER);
    contentPane.add(closePanel, BorderLayout.PAGE_END);
    contentPane.setOpaque(true);
    setContentPane(contentPane);

    //Show it.
    setSize(new Dimension(300, 160));
    setLocationRelativeTo(frame);
    setVisible(true);

  } // constructor

  public String
  getName()
  {
    String retval = null;
    if (nameField != null) {
      retval = nameField.getText();
    }
    return retval;
  } // getName

  public String
  getAmnt()
  {
    String retval = null;
    if (amntField != null) {
      retval = amntField.getText();
    }
    return retval;
  } // getAmnt

  public void
  clear()
  {
    nameField.setText(null);
    amntField.setText(null);
  } // clear

} // class AcctDialog
