package net.multitool.gui;         // Copyright (C) 2004 by Carl Albing and Michael Schwarz
                                   // Licensed under the terms of the GNU GPL version 2.  
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.util.*;
import net.multitool.core.*;

/**
 * This class is the main application class for the BudgetPro gui
 */

public class
BudgetPro
{
  Account top;
  Account current;

  // gui components
  private JFrame frame;   // needed by dialogs to root themselves
  private JLabel nam;
  private JLabel tot;
  private JLabel val;
  private JButton upton = new JButton(
                    new ImageIcon("net/multitool/gui/back.gif"));
  private JButton creat = new JButton("New Subaccount");
  private JButton view  = new JButton("View Subaccount");
  private JButton clos  = new JButton("Quit");

  private JTable list;
  private AbstractTableModel model;

  private AcctDialog askem;   // make once, use often

  // Set Up an Action for a Button
  private ActionListener upAction = new ActionListener()
  {
    public void
    actionPerformed(ActionEvent e)
    {
      // this is the action for UP arrow icon;
      Account next;
      next = current.getParent();
      if (next != null) {
        current = next;
        setStatus();
        // TODO: notify the table, too
        model.fireTableDataChanged();
      } // TODO: else infodialog or Beep.
    }
  } ;

  private ActionListener cdAction = new ActionListener()
  {
    public void
    actionPerformed(ActionEvent e)
    {
      // this is the action for VIEW subdirectory;
      // a "cd" into the subaccount.
      int row = list.getSelectedRow();
      // System.out.println("Row="+row); // DEBUG; TODO: REMOVE
      if (row > -1) {             // only if a row was selected
        String subname = (String) model.getValueAt(row, 0); // name column
        Account next = current.getSub(subname);
        if (next != null) {
          current = next;
          // System.out.println("cd to:"+current.getName());
          setStatus();
          // notify the table, too
          model.fireTableDataChanged();
        } // TODO: else infodialog or Beep.
      }
    }
  } ;

  // TEST ONLY:
  int testid = 0;

  BudgetPro(JFrame frame, String username, String value)
  {
    this.frame = frame;
    top = new Account("TopLevel", new User(username), value);
    current = top;

  } // constructor

  private Component
  createStatus()
  {
    JPanel retval = new JPanel();   // default: flow layout

    upton.addActionListener(upAction);

    nam = new JLabel("Account: Name");
    tot = new JLabel("Total: $");
    val = new JLabel("Remaining: $");

    retval.add(upton);
    retval.add(nam);
    retval.add(tot);
    retval.add(val);

    setStatus();

    return retval;
  } // createStatus

  /**
   * Set the values of the status fields,
   * as when the account has changed.
   */
  private void
  setStatus()
  {
    nam.setText("Account: "+current.getName());
    tot.setText("Total: $"+current.getTotal());
    // tot.setText("SubAccounts: "+current.size());
    val.setText("Remaining: $"+current.getBalance());

    // disable the button if there is no "up" to go
    if (current.getParent() == null) {
        upton.setEnabled(false);
    } else {
        upton.setEnabled(true);
    }

  } // setStatus

  private Component
  createList()
  {
    JScrollPane retval;

    model = new AbstractTableModel()
      {
        private String [] columnNames = {"Account", "Owner", "Value"};

        public String
        getColumnName(int col) {
          return columnNames[col];
        } // getColumnName

        public int
        getRowCount()
        {
          int retval;

          if (current != null) {
              retval = current.size();
          } else {
              retval = 1;     // testing only
          }

          return retval;

        } // getRowCount

        public int getColumnCount() { return columnNames.length; }

        public Object
        getValueAt(int row, int col) {
          Object retval = null;
          Account aa = null;
          // return "---";   // rowData[row][col];
          int count = 0;
          for (Iterator itr=current.getAllSubs(); itr.hasNext(); )
          {
            count++;
            aa = (Account) itr.next();
            if (count > row) { break; }
          } // next
          switch (col) {
          case 0:
                  retval = aa.getName();
                  break;
          case 1:
                  retval = aa.getOwner();
                  break;
          case 2:
                  retval = aa.getTotal();
                  break;
          } // endswitch
          return retval;
        } // getValueAt

        public boolean
        isCellEditable(int row, int col)
        {
          return false;
        } // isCellEditable
      };
    list = new JTable(model);
    list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

    list.getSelectionModel().addListSelectionListener(
      new ListSelectionListener()
      {
        public void
        valueChanged(ListSelectionEvent e)
        {
          ListSelectionModel lsm = (ListSelectionModel)e.getSource();
          if (lsm.isSelectionEmpty()) {
              view.setEnabled(false);
          } else {
              view.setEnabled(true);
          }
        } // valueChanged
      }
    );

    retval = new JScrollPane(list);

    return retval;

  } // createList

  private Component
  createButtons(JRootPane root)
  {
    JPanel retval = new JPanel();   // default: flow layout

    //Lay out the buttons from left to right.
    retval.setLayout(new BoxLayout(retval, BoxLayout.X_AXIS));
    retval.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    retval.add(Box.createHorizontalGlue());
    retval.add(creat);
    retval.add(Box.createRigidArea(new Dimension(10, 0)));
    retval.add(view);
    retval.add(Box.createRigidArea(new Dimension(10, 0)));
    retval.add(clos);

    // ---------------------------------------- Define some actions
    ActionListener closAction = new ActionListener()
    {
      public void
      actionPerformed(ActionEvent e)
      {
          System.exit(0);
      }
    } ;
    clos.addActionListener(closAction);

    ActionListener creatAction = new ActionListener()
    {
      public void
      actionPerformed(ActionEvent e)
      {
        Account child;
        // get the info via a Dialog (of sorts)
        if (askem == null) {
            askem = new AcctDialog(frame, "New Subaccount");
        } else {
            askem.clear();
            askem.setVisible(true);
        }
        String subName = askem.getName();
        String subAmnt = askem.getAmnt();

        // if empty, assume the operation was cancelled, else:
        if ((subName != null) && (subName.length() > 0)) {
            child = current.createSub(subName, subAmnt);
            setStatus();
            model.fireTableDataChanged(); // notify the table
        }
      }
    };
    creat.addActionListener(creatAction);

    // function is to get selection from table and cd there
    view.addActionListener(cdAction);
    // but it starts off disabled, since there is no data yet
    view.setEnabled(false);

    // ------------------------------------------------------------
    frame.getRootPane().setDefaultButton(creat);
    clos.grabFocus();

    return retval;

  } // createButtons

  public static void
  main(String[] args)
  {
    BudgetPro app = null;

    //Create the top-level container
    JFrame frame = new JFrame("BudgetPro");

    // ----------- set up the account/app based on the command line args
    try {
        String username = System.getProperty("user.name", "default");
        if (args.length > 0) {
            app = new BudgetPro(frame, username, args[0]);
         } else {
            System.err.println("usage: BudgetPro dollar_amt");
            System.exit(1);
         }
    } catch (Exception e) {
        System.err.println("Error on startup.");
        e.printStackTrace();
        System.exit(2);
    }

    // ----------- now set up the UI and get things going
    try {
        UIManager.setLookAndFeel(
                    UIManager.getCrossPlatformLookAndFeelClassName());
    } catch (Exception e) {
        System.err.println("Can't set the desired look and feel.");
        e.printStackTrace();
        System.exit(3);
    }

    // build the pieces and add them to the top-level container

    Component status = app.createStatus();
    frame.getContentPane().add(status, BorderLayout.NORTH);

    Component list = app.createList();
    frame.getContentPane().add(list, BorderLayout.CENTER);

    Component buttons = app.createButtons(frame.getRootPane());
    frame.getContentPane().add(buttons, BorderLayout.SOUTH);

    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.pack();
    frame.setVisible(true);
  } // main

} // class BudgetPro
