package net.multitool.util;        // Copyright (C) 2004 by Carl Albing and Michael Schwarz
                                   // Licensed under the terms of the GNU GPL version 2.  
import junit.framework.*;

public class
SAMoneyTest
	extends TestCase
{
    protected SAMoney money1;
    protected SAMoney money2;
    protected SAMoney money3;
    protected SAMoney money4;

    public
    SAMoneyTest(String str)
    {
	super(str);
    } // constructor SAMoneyTest

    protected void
    setUp()
    {
	money1 = new SAMoney(127.15);	// $127.15
	money2 = new SAMoney(127, 15);	// $127.15
	money3 = new SAMoney(500, 00);	// $500.00
	money4 = new SAMoney(500, 00);	// $500.00
    } // setUp

    /**
     * constructs a collection of tests to be run by the TestRunner
     */
    public static Test
    suite()
    {
        // can do it this way, by hand:
	TestSuite suite = new TestSuite();

	suite.addTest( new SAMoneyTest("testAdd")
		    {
			protected void runTest() { testAdd(); }
		    });

	suite.addTest( new SAMoneyTest("subtract")
		    {
			protected void runTest() { testSubtract(); }
		    });

	suite.addTest( new SAMoneyTest("Time Value of Money")
		    {
			protected void runTest() { testTvm(); }
		    });

        /*
         * or let the TestRunner class figure it out:
	TestSuite suite = new TestSuite(SAMoneyTest.class);
         */
        
	return suite;

    } // suite

    public void
    testAdd()
    {
	assertEquals(money1.getDollars(), 127);
	assertEquals(money1.getCents(), 15);
        money3.add(money4);
        assertEquals(1000, money3.getDollars());
	

    } // testAdd

    public void
    testSubtract()
    {
        money3.subtract(money4);
        assertEquals(0, money3.getDollars());

    } // testSubtract

    public void
    testTvm()
    {
	
	money3.compound(0.05, 1);
	assertEquals(money3.getDollars(), 525);
	money4.compound(0.05, 2);
	assertEquals(money4.getDollars(), 551);
	assertEquals(money4.getCents(), 25);

    } // testTvm

    public static void
    main(String [] args)
    {
	junit.textui.TestRunner.run(suite());
    } // main

} // class SAMoneyTest
