package net.multitool.Payback;     // Copyright (C) 2004 by Carl Albing and Michael Schwarz
                                   // Licensed under the terms of the GNU GPL version 2.
import net.multitool.util.*;
import java.math.*;
import java.io.*;

/**
 ** The Account class is an abstract class the defines the
 ** interface to an Account.
 **
 ** @version $Id: Account.java,v 1.5 2003/08/31 04:21:52 mschwarz Exp $
 */
public abstract class Account implements Serializable {
	protected String name;
	protected BigDecimal interestRate;

	public Account(String nm, double iRate)
	{
		name = new String(nm);
		interestRate = new BigDecimal(iRate);
	}

	public Account()
	{
		name = null;
		interestRate = null;
	}

	public void setInterest(BigDecimal intRate)
	{
		interestRate = intRate;
	}

	public void setName(String nm)
	{
		name = nm;
	}

	/** getCost returns the real cost of the specified
	 ** Purchase when calaculated against this Account
	 */
	public abstract Cost getCost(Purchase p);
}

