package net.multitool.Payback;     // Copyright (C) 2004 by Carl Albing and Michael Schwarz
                                   // Licensed under the terms of the GNU GPL version 2.  
import java.math.*;
import java.util.*;
import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import net.multitool.Payback.*;

public class Payback
{
   private ArrayList accounts;
   private String filename;
   private Purchase p;

   public Payback(String finm)
   {
	accounts = new ArrayList();
	DocumentBuilder docParser;
	Document doc = null;
	NodeList nl;
	Node curNode;
	Account a = null;

	try {
 		docParser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		doc = docParser.parse(new File(finm));
	} catch (Exception e) {
		e.printStackTrace();
	}

	nl = doc.getElementsByTagName("*");

	for (int i = 0; i < nl.getLength(); i++)
	{
		curNode = nl.item(i);

		if (curNode.getNodeName().equals("savingsaccount")) {
			a = new SavingsAccount();
			accounts.add(a);
		} else if (curNode.getNodeName().equals("debtaccount")) {
			a = new DebtAccount();
		} else if (curNode.getNodeName().equals("purchase")) {
			p = new Purchase(0.0, 0.0);
		} else if (curNode.getNodeName().equals("interest")) {
			a.setInterest(new BigDecimal(curNode.getFirstChild().getNodeValue()));
		} else if (curNode.getNodeName().equals("name")) {
			a.setName(curNode.getFirstChild().getNodeValue());
		} else if (curNode.getNodeName().equals("payment")) {
			p.setPayment(curNode.getFirstChild().getNodeValue());
		} else if (curNode.getNodeName().equals("price")) {
			p.setPrice(curNode.getFirstChild().getNodeValue());
		}
	}

   	if (finm != null) {
   	      filename = finm;
   	}

   }

   /**
    * Iterates over the ArrayList of accounts and reports
    * the number of payments and the real dollars out of pocket
    * assuming monthly payments of "payment" and the interest rates
    * specified for the account.
    */
   public void reportPurchase(Purchase p)
   {
   }

   public Purchase getPurchase()
   {
      return p;
   }

   public void saveAppState(String finm) throws FileNotFoundException, IOException
   {
      // Save the objects
      ObjectOutputStream o = new ObjectOutputStream(new FileOutputStream(finm));
      o.writeObject(accounts);
      o.flush();
   }

   public void restoreAppState(String finm)
   {
      // Restore the objects
   }

   public static void main(String[] args)
   {
      Payback app;
      Purchase p;
   
      if (args.length < 1)
      {
         app = new Payback("PBAccounts.xml");
      } else {
         app=new Payback(args[0]);
      }

      p = app.getPurchase();

      System.out.println("Payback -- A savings/credit comparison tool");
      System.out.println("Copyright (C) 2003 by Carl Albing and Michael Schwarz");
      System.out.println("Released under the GNU/GPL.  Free Software.");

      app.reportPurchase(p);

      try {
         app.saveAppState("testObjStream");
      } catch (Exception e) {
         e.printStackTrace();
      }
   }
}
 
