package net.multitool.Payback;     // Copyright (C) 2004 by Carl Albing and Michael Schwarz
                                   // Licensed under the terms of the GNU GPL version 2.  
import java.math.*;
import java.io.*;

public class Purchase {
	private BigDecimal pmtAmt;
	private BigDecimal retailPrice;

	/**
	* pmt is the monthly payment you are willing to make to make the
	* purchase.  price is the purchase price of the item in dollars.
	*/
	public Purchase(double pmt, double price)
	{
		pmtAmt = new BigDecimal(pmt);
		retailPrice = new BigDecimal(price);
	}

	/**
	* This contructor uses standard in and stdout to
	* construct the purchase
	*/
	public Purchase()
	{
		BufferedReader rd = new BufferedReader(new InputStreamReader(System.in));

		try {
			System.out.println("Enter the purchase price of the item:");
			retailPrice = new BigDecimal(rd.readLine());
			System.out.println("Enter the monthly payment you are willing to make:");
			pmtAmt = new BigDecimal(rd.readLine());
		} catch (IOException e) {
			// Set defaults in case of IO Error
			pmtAmt = null;
			retailPrice = null;
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
		

	public void setPayment(String pmt)
	{
		pmtAmt = new BigDecimal(pmt);
	}

	public void setPrice(String price)
	{
		retailPrice = new BigDecimal(price);
	}

	public BigDecimal getPayment()
	{
		return pmtAmt;
	}

	public BigDecimal getPrice()
	{
		return retailPrice;
	}
}

