package net.multitool.util;       // Copyright (C) 2003,2004 by Carl Albing and Michael Schwarz
                                  // Licensed under the terms of the GNU GPL version 2.  
import java.math.*;

/**
 * the Schwarz-Albing Money class: SAMoney.
 * It provides some additional features for money,
 * esp. Time Value of Money computations.
 */
public class
SAMoney
{
    private BigDecimal val;

    public
    SAMoney()
    {
    } // constructor

    public
    SAMoney(double dollarsandcents)
    {
	val = (new BigDecimal(dollarsandcents));
	// val = val.setScale(2);
    } // constructor

    public
    SAMoney(int dollars, int cents)
    {
	double dollarsandcents = dollars+(cents/100.0);
	val = (new BigDecimal(dollarsandcents));
	// val = val.setScale(2);
    } // constructor

    public
    SAMoney(SAMoney othermoney)
    {
	val = null;
	if (othermoney != null) {
	    BigDecimal otherval = othermoney.val;
	    if (otherval != null) {
		// val = otherval.setScale(2);
		val = otherval;
	    }
	}
    } // constructor

    double
    doubleValue()
    {
        return val.doubleValue();

    } // doubleValue

    public String
    toString()
    {
	String retval = "";
	// TODO: locale stuff
	retval = val.toString();
	return retval;
    } // toString

    public int
    getDollars()
    {
	int retval;
	retval = val.intValue();
	return retval;
    } // getDollars

    public int
    getCents()
    {
	int retval;
	SAMoney dolrval = new SAMoney(getDollars(), 0);
	// cents = (dollars.cents - dollars) * 100
	retval = val.subtract(dolrval.val).movePointRight(2).intValue();

	return retval;

    } // getCents

    public SAMoney
    add(SAMoney moremoney)
    {
	val.add(moremoney.val);
	return this;
    } // add

    public SAMoney
    subtract(SAMoney somemoney)
    {
	val.subtract(somemoney.val);
	return this;
    } // subtract

    public SAMoney
    multiply(SAMoney bymoney)
    {
	val.multiply(bymoney.val);
	return this;
    } // multiply

    public SAMoney
    divide(SAMoney bymoney)
    {
	val.divide(bymoney.val, BigDecimal.ROUND_HALF_UP);
	return this;
    } // divide

    /*
     * Time Value of Money calculations
     * 
     * should these return "this", so as to be able to chain operations?
     */

    /**
     * compound this number at the given interestRate for the given periods.
     */
    public void
    compound(double interestRate, int periods)
    {
	// v*((1+interest)^periods)
	BigDecimal tmp = new BigDecimal(java.lang.StrictMath.pow((1.0+interestRate),(double)periods));
	val = val.multiply(tmp);
    } // compound

    /**
     * In technical terms, assuming that the SAMoney is a "future value",
     * convert the given SAMoney to a "present value"
     * at the given interestRate over the given number of periods.
     * Answers the quesiton: "how much do I need to put aside today,
     * at the given interestRate over the given number of periods,
     * to arrive at this value?"
     */
    public void
    today(double irate, int periods)
    {
	// PV(0) = FV(n)/((1+(i))^n)
	BigDecimal tmp = new BigDecimal(java.lang.StrictMath.pow((1.0+(irate/periods)), (double)periods));
	val = val.divide(tmp, BigDecimal.ROUND_HALF_UP);
    } // today

    /***********************************************************
     * Some utility classes provided by SAMoney follow.
     * As  utility classes we define them as static so that
     * anyone can use them without an instance of an SAMoney
     * object, and public so that anyone can use them.
     */

    /**
     * returns the "cost" of saving amt by making payments
     * at an interest rate until amt is met or exceeded.
     */
    public static Cost
    Save(double amt, double rate, double paymnt)
    {
        double sum;
        double irate;
        double pay;
        double cost;
        int months;

        months = 0;
        pay = paymnt;
        sum = pay;
        irate = 1.0+(rate/12.0);

        while (sum < amt) {
            months++;
            sum = (sum*irate)+pay;
        }

        return new Cost(months, sum);

    } // Save

    /**
     * compute the real cost of paying of a debt of amt
     * by making payments while incurring an interest
     * rate on the debt.
     */
    public static Cost
    Debt(double amt, double rate, double paymnt)
    {
        double debt;
        double irate;
        double pay;
        double cost;
        int months;

        months = 0;
        debt = amt;
        pay = paymnt;
        irate = rate/12.0;

        cost = debt;
        while (debt > 0) {
            months++;
            cost += debt*irate;
            debt -= pay;
        }

        return new Cost(months, cost);

    } // Debt

} // class SAMoney
