package net.multitool.util;       // Copyright (C) 2003,2004 by Carl Albing and Michael Schwarz
                                  // Licensed under the terms of the GNU GPL version 2.  
import junit.framework.*;

public class
SAMoneyTest
	extends TestCase
{
    protected SAMoney money1;
    protected SAMoney money2;
    protected SAMoney money3;
    protected SAMoney money4;

    SAMoneyTest(String str)
    {
	super(str);
    } // constructor SAMoneyTest

    protected void
    setUp()
    {
	money1 = new SAMoney(127.15);	// $127.15
	money2 = new SAMoney(127, 15);	// $127.15
	money3 = new SAMoney(500, 00);	// $500.00
	money4 = new SAMoney(500, 00);	// $500.00
    } // setUp

    public static Test
    suite()
    {
	TestSuite suite = new TestSuite();

	suite.addTest( new SAMoneyTest("add")
		    {
			protected void runTest() { testAdd(); }
		    });

	suite.addTest( new SAMoneyTest("tvm")
		    {
			protected void runTest() { testTvm(); }
		    });

	return suite;

    } // suite

    public void
    testAdd()
    {
	assertEquals(money1.getDollars(), 127);
	assertEquals(money1.getCents(), 15);
	//assertEquals(money1, money2);

    } // testAdd

    public void
    testTvm()
    {
	
	money3.compound(0.05, 1);
	assertEquals(money3.getDollars(), 525);
	money4.compound(0.05, 2);
	assertEquals(money4.getDollars(), 551);
	assertEquals(money4.getCents(), 25);

    } // testTvm

    public static void
    main(String [] args)
    {
	junit.textui.TestRunner.run(suite());
    } // main

} // class SAMoneyTest
